/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.awt.validators;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class DecimalVerifier
extends InputVerifier
implements ActionListener {
    private int inteiros;
    private int decimais;
    private boolean obrigatorio;

    public DecimalVerifier(int inteiros, int decimais, boolean obrigatorio) {
        this.inteiros = inteiros;
        this.decimais = decimais;
        this.obrigatorio = obrigatorio;
    }

    @Override
    public boolean verify(JComponent input) {
        JTextField textField = (JTextField)input;
        if (this.obrigatorio && (null == textField.getText() || "".equals(textField.getText().trim()))) {
            textField.setBackground(Color.RED);
            textField.setText("Campo obrigat\u00f3rio");
            return false;
        }
        if (!textField.getText().matches("^\\d{1," + this.inteiros + "}+(\\.\\d{0," + this.decimais + "})?$")) {
            textField.setBackground(Color.RED);
            return false;
        }
        textField.setBackground(Color.WHITE);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextField source = (JTextField)e.getSource();
        this.shouldYieldFocus(source);
        source.selectAll();
    }
}

