/*
 * Decompiled with CFR 0.152.
 */
package br.com.providernt.io.excel;

import br.com.providernt.io.excel.Coluna;
import br.com.providernt.io.excel.XLSCell;
import br.com.providernt.io.excel.XLSException;
import br.com.providernt.io.excel.XLSStyleALM;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XLSRow
implements Serializable,
Comparable<XLSRow> {
    private static final long serialVersionUID = 4392943838230208414L;
    public static final int MAX_COLUNAS = 255;
    private int maiorCelula = 0;
    private final Map<Integer, XLSCell> celulas = new HashMap<Integer, XLSCell>();
    private final int indexRow;

    public XLSRow(int indexRow) {
        this.indexRow = indexRow;
    }

    public final XLSRow addCell(int posicaoCelula, String conteudo) {
        return this.addCell(posicaoCelula, conteudo, null);
    }

    public final XLSRow addCell(int posicaoCelula, String conteudo, XLSStyleALM estilo) {
        XLSCell cell;
        XLSRow.validaPosicaoCelula(posicaoCelula);
        if (null == conteudo) {
            conteudo = "";
        }
        if (null == (cell = this.celulas.get(posicaoCelula))) {
            cell = new XLSCell(posicaoCelula, conteudo);
            this.celulas.put(posicaoCelula, cell);
        } else {
            cell.setValor(conteudo);
        }
        cell.setEstilo(estilo);
        if (posicaoCelula > this.maiorCelula) {
            this.maiorCelula = posicaoCelula;
        }
        return this;
    }

    public final XLSRow addCells(String ... conteudo) {
        return this.addCells((XLSStyleALM)null, conteudo);
    }

    public final XLSRow addCells(XLSStyleALM estilo, String ... conteudo) {
        if (null != conteudo) {
            for (int i = 0; i < conteudo.length; ++i) {
                this.addCell(i, conteudo[i], estilo);
            }
        }
        return this;
    }

    public final XLSRow addNextCell(String conteudo) {
        return this.addCell(this.getNextIndex(), conteudo);
    }

    public final int getNextIndex() {
        return this.maiorCelula + 1;
    }

    public final int getIndexRow() {
        return this.indexRow;
    }

    public final String getCell(int posicao) {
        XLSCell celula = this.celulas.get(posicao);
        String valor = "";
        if (null != celula) {
            valor = celula.getValor();
        }
        return valor;
    }

    public final List<XLSCell> getCells() {
        ArrayList<XLSCell> c = new ArrayList<XLSCell>(this.celulas.values());
        Collections.sort(c);
        return c;
    }

    public static final void validaPosicaoCelula(int posicaoCelula) {
        if (posicaoCelula < 0 || posicaoCelula > 255) {
            throw new IllegalArgumentException("C\u00e9lula (" + posicaoCelula + ") inv\u00e1lida. Permitida entre 0 e " + 255 + ".");
        }
    }

    public final int converte(String stringPosicaoCelula) throws XLSException {
        if (null == stringPosicaoCelula || "".equals(stringPosicaoCelula)) {
            throw new IllegalArgumentException("Coluna n\u00e3o pode ser nulo ou vazio.");
        }
        if (stringPosicaoCelula.length() > 2) {
            throw new IllegalArgumentException("N\u00e3o \u00e9 permitido mais de 2 (dois) caracteres.");
        }
        int tot = 0;
        Coluna colunaEnum = null;
        try {
            char letra;
            for (int i = 0; i < stringPosicaoCelula.length(); ++i) {
                char letra2 = stringPosicaoCelula.charAt(i);
                if (Character.isLetter(letra2)) continue;
                throw new IllegalArgumentException("Coluna '" + stringPosicaoCelula + "' inv\u00e1lida. Aceita somente letras de A a Z.");
            }
            if ((stringPosicaoCelula = stringPosicaoCelula.toUpperCase()).length() == 1) {
                letra = stringPosicaoCelula.charAt(0);
                colunaEnum = Coluna.valueOf(String.valueOf(letra));
                tot = colunaEnum.getSequencia();
            } else if (stringPosicaoCelula.length() == 2) {
                letra = stringPosicaoCelula.charAt(0);
                colunaEnum = Coluna.valueOf(String.valueOf(letra));
                tot = Coluna.getTotal() * (colunaEnum.getSequencia() + 1);
                letra = stringPosicaoCelula.charAt(1);
                colunaEnum = Coluna.valueOf(String.valueOf(letra));
                tot += colunaEnum.getSequencia();
            }
        }
        catch (Exception e) {
            throw new XLSException("N\u00e3o foi poss\u00edvel converter CelulaString para indexCelula.", e);
        }
        finally {
            colunaEnum = null;
        }
        if (tot > 255) {
            throw new IllegalArgumentException("Coluna '" + stringPosicaoCelula + "' inv\u00e1lida. Permitido de 'A' at\u00e9 'IV'.");
        }
        return tot;
    }

    @Override
    public int compareTo(XLSRow o) {
        if (this.indexRow < o.indexRow) {
            return -1;
        }
        if (this.indexRow > o.indexRow) {
            return 1;
        }
        return 0;
    }
}

