/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.message;

import com.jgoodies.common.base.Objects;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.message.AbstractValidationMessage;

public class PropertyValidationMessage
extends AbstractValidationMessage {
    private final Object target;
    private final String role;
    private final String property;

    public PropertyValidationMessage(String text, Object target, String role, String property) {
        this(Severity.WARNING, text, target, role, property);
    }

    public PropertyValidationMessage(Severity severity, String text, Object target, String role, String property) {
        super(text, severity);
        this.target = Preconditions.checkNotNull(target, "The target must not be null.");
        this.role = Preconditions.checkNotNull(role, "The role must not be null.");
        this.property = Preconditions.checkNotNull(property, "The property must not be null.");
    }

    public final Object target() {
        return this.target;
    }

    public final String role() {
        return this.role;
    }

    public final String property() {
        return this.property;
    }

    public String aspect() {
        return this.role() + "." + this.property();
    }

    @Override
    public String formattedText() {
        return this.aspect() + " " + this.text();
    }

    @Override
    public Object key() {
        return this.aspect();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyValidationMessage)) {
            return false;
        }
        PropertyValidationMessage other = (PropertyValidationMessage)o;
        return this.severity().equals((Object)other.severity()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.property(), other.property());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.severity().hashCode();
        result = 37 * result + (this.text() == null ? 0 : this.text().hashCode());
        result = 37 * result + (this.target() == null ? 0 : this.target().hashCode());
        result = 37 * result + (this.role() == null ? 0 : this.role().hashCode());
        result = 37 * result + (this.property() == null ? 0 : this.property().hashCode());
        return result;
    }
}

