/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.servico.client;

import br.com.bancooriginal.cyberbank.exception.CyberBankException;
import br.com.bancooriginal.cyberbank.util.CBUtil;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;

public abstract class BaseClient {
    protected abstract String getWsdl();

    protected abstract String getNamespaceURI();

    protected abstract String getLocalPart();

    public Object getPort(Class<?> classPort) throws CyberBankException {
        Object port = null;
        try {
            URL url = new URL(this.getWsdl());
            QName qname = new QName(this.getNamespaceURI(), this.getLocalPart());
            Service service = Service.create(url, qname);
            port = service.getPort(classPort);
            String wsdlLocation = url.getProtocol() + "://" + url.getAuthority() + url.getPath();
            ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", wsdlLocation);
        }
        catch (MalformedURLException e) {
            throw new CyberBankException(CBUtil.getMensagem("error.cyberbank.service.url.invalida"), e);
        }
        catch (Exception e) {
            throw new CyberBankException(CBUtil.getMensagem("error.cyberbank.service.connection"), e);
        }
        return port;
    }
}

