/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.servico.client;

import br.com.bancooriginal.cyberbank.dto.Parametrizacao;
import br.com.bancooriginal.cyberbank.exception.CyberBankException;
import br.com.bancooriginal.cyberbank.servico.client.MensagemHandler;
import br.com.bancooriginal.cyberbank.util.SessionIdGenerator;
import br.com.bancooriginal.cyberbank.util.XMLUtil;
import java.awt.Color;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPFaultException;
import net.technisys.cmm.services.errors.v1.Errors;
import net.technisys.cmm.services.metadata.v1.Metadata;
import net.technisys.cmm.services.processuserloginbackoffice.rq.v1.Branch;
import net.technisys.cmm.services.processuserloginbackoffice.rq.v1.Channel;
import net.technisys.cmm.services.processuserloginbackoffice.rq.v1.Institution;
import net.technisys.cmm.services.processuserloginbackoffice.rq.v1.ProcessUserLoginBackofficeRequest;
import net.technisys.cmm.services.processuserloginbackoffice.rq.v1.SystemUser;
import net.technisys.cmm.services.processuserloginbackoffice.rs.v1.ProcessUserLoginBackofficeResponse;
import net.technisys.cmm.services.seguridad.v1.LoginFault;
import net.technisys.cmm.services.seguridad.v1.ProcessUserLoginBackoffice;
import net.technisys.cmm.services.seguridad.v1.Seguridad;

public class SecurityClient {
    String enderecoServico;
    String resposta;

    public void autenticar() throws CyberBankException {
        try {
            String novasessao = SessionIdGenerator.generateSessionId();
            Parametrizacao parametrizacao = XMLUtil.lerConfiguracoes(new File("parametrizacao.xml"));
            System.out.println("ENDERECO ATUAL:  " + parametrizacao.getEndereco());
            Metadata metadata = new Metadata();
            metadata.setServiceId("processUserLoginBackoffice");
            metadata.setServiceVersion("1.0");
            metadata.setServiceContext("Tech");
            SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddHHMMsshhh");
            metadata.setChannelDispatchDate(sd.format(new Date()));
            metadata.setSessionId(novasessao);
            metadata.setUserId(parametrizacao.getUserId());
            metadata.setExecutingOperatorId(parametrizacao.getUserId());
            metadata.setInstitutionId(parametrizacao.getInstitutionId());
            metadata.setBranchId(parametrizacao.getBranchId());
            Metadata.CustomProperties custom = new Metadata.CustomProperties();
            custom.setServiceContext("Tech");
            metadata.setCustomProperties(custom);
            Metadata.ExecutingChannel executingChannel = new Metadata.ExecutingChannel();
            executingChannel.setMnemonic("8");
            metadata.setExecutingChannel(executingChannel);
            ProcessUserLoginBackofficeRequest request = new ProcessUserLoginBackofficeRequest();
            Branch branch = new Branch();
            branch.setBranchId(parametrizacao.getBranchId());
            branch.setId(parametrizacao.getBranchId());
            branch.setName("branch");
            branch.setDataModel("product.financials");
            branch.setVersion("1.0");
            Channel channel = new Channel();
            channel.setChannelId(parametrizacao.getChannelId());
            channel.setName("channel");
            channel.setDataModel("product.financials");
            channel.setVersion("1.0");
            Institution institution = new Institution();
            institution.setInstitutionId(parametrizacao.getInstitutionId());
            institution.setName("institution");
            institution.setDataModel("product.financials");
            institution.setVersion("1.0");
            SystemUser systemUser = new SystemUser();
            systemUser.setUserId(parametrizacao.getUserId());
            systemUser.setName("user");
            systemUser.setDataModel("product.financials");
            systemUser.setVersion("1.0");
            request.setBranch(branch);
            request.setChannel(channel);
            request.setInstitution(institution);
            request.setSystemUser(systemUser);
            ArrayList<Handler> handlerChain = new ArrayList<Handler>();
            handlerChain.add(new MensagemHandler());
            Holder<Metadata> holder = new Holder<Metadata>();
            holder.value = metadata;
            ProcessUserLoginBackoffice service = new ProcessUserLoginBackoffice();
            Seguridad port = service.getProcessUserLoginBackofficePort();
            BindingProvider bindingProvider = (BindingProvider)((Object)port);
            this.enderecoServico = parametrizacao.getEndereco();
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.enderecoServico);
            bindingProvider.getBinding().setHandlerChain(handlerChain);
            ProcessUserLoginBackofficeResponse response = null;
            try {
                response = port.processUserLoginBackoffice(request, holder);
            }
            catch (LoginFault e) {
                System.out.println("LOGINFAULT:::::::::::::::::");
                e.printStackTrace();
                Errors erros = e.getFaultInfo();
                if (null != erros) {
                    List<Errors.Error> erroslist = erros.getError();
                    this.resposta = "";
                    if (null != erroslist && !erroslist.isEmpty()) {
                        for (Errors.Error erro : erroslist) {
                            this.resposta = this.resposta + erro.getDetail() + "###";
                        }
                    }
                    throw new CyberBankException(this.resposta);
                }
            }
            catch (SOAPFaultException se) {
                System.out.println("SOAPFAULTEXCEPTION:::::::::::::::::");
                se.printStackTrace();
                throw new CyberBankException(se.getMessage());
            }
            catch (RuntimeException r) {
                System.out.println("RUNTIMEEXCEPTION:::::::::::::::::");
                r.printStackTrace();
                throw new CyberBankException("N\u00e3o foi poss\u00edvel conectar o servi\u00e7o em: " + this.enderecoServico + "### Causa: " + r.getMessage());
            }
            catch (Exception e) {
                System.out.println("EXCEPTION:::::::::::::::::");
                e.printStackTrace();
                String erro = "";
                for (StackTraceElement st : e.getStackTrace()) {
                    erro = erro + st.toString() + "###";
                }
                JDialog d = new JDialog();
                d.setSize(600, 600);
                JLabel critica = new JLabel(erro);
                critica.setForeground(Color.RED);
                d.add(critica);
                d.setVisible(true);
                e.printStackTrace();
                throw new CyberBankException(e.getMessage());
            }
            XMLUtil.escreverAtributoParametrizacao("sessionId", novasessao);
        }
        catch (Exception e) {
            System.out.println("ULTIMAEXCECAO:::::::::::::");
            e.printStackTrace();
            throw new CyberBankException(e.getMessage());
        }
    }
}

