/*
 * Decompiled with CFR 0.152.
 */
package br.com.providernt.io.excel;

import br.com.providernt.io.excel.StyleTypeEnum;
import br.com.providernt.io.excel.XLSCell;
import br.com.providernt.io.excel.XLSException;
import br.com.providernt.io.excel.XLSRow;
import br.com.providernt.io.excel.XLSStyleALM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

abstract class XLSExport
implements Serializable {
    private static final long serialVersionUID = 7935092664924453863L;
    private HSSFCellStyle styleHeader = null;
    private HSSFCellStyle styleBody = null;

    XLSExport() {
    }

    protected abstract List<Short[]> getMergeCelulas();

    protected abstract String getNomeArquivo();

    protected abstract List<XLSRow> getRows();

    protected abstract List<Integer[]> getLarguraColuna();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InputStream exportar() throws XLSException {
        HSSFWorkbook workbook = null;
        ByteArrayOutputStream xlsByte = null;
        ByteArrayInputStream is = null;
        try {
            workbook = this.gerarExcel();
            xlsByte = new ByteArrayOutputStream();
            workbook.write(xlsByte);
            is = new ByteArrayInputStream(xlsByte.toByteArray());
            return is;
        }
        catch (XLSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XLSException("N\u00e3o foi poss\u00edvel exportar Excel.", e);
        }
        finally {
            workbook = null;
            try {
                try {
                    if (null != xlsByte) {
                        xlsByte.flush();
                        xlsByte.close();
                    }
                    xlsByte = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    xlsByte = null;
                }
            }
            catch (Throwable throwable) {
                xlsByte = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void exportar(File arquivo) throws XLSException {
        HSSFWorkbook workbook = null;
        FileOutputStream fos = null;
        try {
            workbook = this.gerarExcel();
            fos = new FileOutputStream(arquivo);
            workbook.write(fos);
            return;
        }
        catch (XLSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XLSException("N\u00e3o foi poss\u00edvel exportar Excel.", e);
        }
        finally {
            workbook = null;
            if (null != fos) {
                try {
                    try {
                        fos.flush();
                        fos.close();
                        fos = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        fos = null;
                    }
                }
                catch (Throwable throwable) {
                    fos = null;
                    throw throwable;
                }
            }
        }
    }

    private final HSSFWorkbook gerarExcel() throws XLSException {
        HSSFWorkbook workbook = null;
        HSSFSheet firstSheet = null;
        HSSFRow row = null;
        try {
            workbook = new HSSFWorkbook();
            firstSheet = workbook.createSheet(this.getNomeArquivo());
            for (Short[] mc : this.getMergeCelulas()) {
                firstSheet.addMergedRegion(new CellRangeAddress(mc[0].shortValue(), mc[1].shortValue(), mc[2].shortValue(), mc[3].shortValue()));
            }
            for (Integer[] lc : this.getLarguraColuna()) {
                firstSheet.setColumnWidth(lc[0], lc[1]);
            }
            for (XLSRow xlsRow : this.getRows()) {
                row = firstSheet.createRow(xlsRow.getIndexRow());
                for (XLSCell c : xlsRow.getCells()) {
                    this.createCell(workbook, row, c);
                }
            }
        }
        catch (XLSException e) {
            throw e;
        }
        catch (Exception e) {
            workbook = null;
            firstSheet = null;
            row = null;
            throw new XLSException("N\u00e3o foi poss\u00edvel gerar Excel.", e);
        }
        return workbook;
    }

    private final Cell createCell(HSSFWorkbook workbook, HSSFRow row, XLSCell celula) throws XLSException {
        if (null == workbook) {
            throw new XLSException("HSSFWorkbook (excel) n\u00e3o pode ser nulo.");
        }
        if (null == row) {
            throw new XLSException("HSSFRow (linha) n\u00e3o pode ser nulo.");
        }
        if (null == celula) {
            throw new XLSException("XLSCell (c\u00e9lula) n\u00e3o pode ser nulo.");
        }
        HSSFCell cell = null;
        try {
            cell = row.createCell(celula.getIndexCell());
            cell.setCellValue(celula.getValor());
            XLSStyleALM estilo = celula.getEstilo();
            if (null != estilo) {
                if (estilo.getStyleType() == StyleTypeEnum.BODY) {
                    if (null == this.styleBody) {
                        this.styleBody = this.createCellStyle(StyleTypeEnum.BODY, workbook, estilo);
                        cell.setCellStyle((CellStyle)this.styleBody);
                    }
                } else if (estilo.getStyleType() == StyleTypeEnum.BODY && null == this.styleHeader) {
                    this.styleHeader = this.createCellStyle(StyleTypeEnum.HEADER, workbook, estilo);
                    cell.setCellStyle((CellStyle)this.styleHeader);
                }
            }
        }
        catch (Exception e) {
            throw new XLSException("N\u00e3o foi poss\u00edvel criar c\u00e9lula.", e);
        }
        return cell;
    }

    private HSSFCellStyle createCellStyle(StyleTypeEnum styleType, HSSFWorkbook workbook, XLSStyleALM estilo) {
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        if (estilo.isBordaTopo()) {
            cellStyle.setBorderTop(estilo.getBordaEstilo());
            cellStyle.setTopBorderColor(estilo.getBordaCor());
        }
        if (estilo.isBordaBase()) {
            cellStyle.setBorderBottom(estilo.getBordaEstilo());
            cellStyle.setBottomBorderColor(estilo.getBordaCor());
        }
        if (estilo.isBordaEsquerda()) {
            cellStyle.setBorderLeft(estilo.getBordaEstilo());
            cellStyle.setLeftBorderColor(estilo.getBordaCor());
        }
        if (estilo.isBordaDireita()) {
            cellStyle.setBorderRight(estilo.getBordaEstilo());
            cellStyle.setRightBorderColor(estilo.getBordaCor());
        }
        if (estilo.getAlinhamento() < 0) {
            cellStyle.setAlignment((short)1);
        } else if (estilo.getAlinhamento() > 0) {
            cellStyle.setAlignment((short)3);
        } else {
            cellStyle.setAlignment((short)2);
        }
        if (estilo.isNegrito()) {
            font.setBoldweight((short)700);
        }
        if (null != estilo.getCor()) {
            font.setColor(estilo.getCor());
        }
        font.setItalic(estilo.isItalico());
        return cellStyle;
    }
}

