/*
 * Decompiled with CFR 0.152.
 */
package br.com.providernt.util;

import br.com.providernt.util.ArquivoUtilException;
import br.com.providernt.util.NekiUtil;
import br.com.providernt.util.TipoArquivo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArquivoUtil {
    private static final Logger logger = LoggerFactory.getLogger(ArquivoUtil.class);

    public static void renomear(File arquivoOrigem, String novoNome) throws ArquivoUtilException {
        if (null == arquivoOrigem) {
            throw new ArquivoUtilException("Arquivo origem inv\u00e1lido ou inexistente.");
        }
        if (!arquivoOrigem.exists()) {
            throw new ArquivoUtilException("Arquivo origem inv\u00e1lido ou inexistente.");
        }
        if (null == novoNome || "".equals(novoNome.trim())) {
            throw new ArquivoUtilException("Novo nome para arquivo inv\u00e1lido.");
        }
        File novoArqDestino = null;
        try {
            novoArqDestino = new File(NekiUtil.getPath(arquivoOrigem), novoNome);
            if (arquivoOrigem.renameTo(novoArqDestino)) {
                arquivoOrigem.delete();
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("N\u00e3o foi poss\u00edvel renomear arquivo.", e);
        }
        finally {
            novoArqDestino = null;
        }
    }

    public static void mover(File arquivoOrigem, File diretorioDestino) throws ArquivoUtilException {
        ArquivoUtil.copiar(arquivoOrigem, diretorioDestino, true);
    }

    public static void copiar(File arquivoOrigem, File diretorioDestino) throws ArquivoUtilException {
        ArquivoUtil.copiar(arquivoOrigem, diretorioDestino, false);
    }

    private static void copiar(File arquivoOrigem, File diretorioDestino, boolean apagarOrigem) throws ArquivoUtilException {
        if (null == arquivoOrigem) {
            throw new ArquivoUtilException("Arquivo origem inv\u00e1lido ou inexistente.");
        }
        if (!arquivoOrigem.exists()) {
            throw new ArquivoUtilException("Arquivo origem inv\u00e1lido ou inexistente.");
        }
        if (!arquivoOrigem.isFile()) {
            throw new ArquivoUtilException("Arquivo origem n\u00e3o \u00e9 um arquivo v\u00e1lido.");
        }
        if (null == diretorioDestino) {
            throw new ArquivoUtilException("Diret\u00f3rio destino inv\u00e1lido ou inexistente.");
        }
        if (!diretorioDestino.exists()) {
            throw new ArquivoUtilException("Diret\u00f3rio destino inv\u00e1lido ou inexistente.");
        }
        if (!diretorioDestino.isDirectory()) {
            throw new ArquivoUtilException("Diret\u00f3rio destino n\u00e3o \u00e9 um diret\u00f3rio v\u00e1lido.");
        }
        InputStream is = null;
        OutputStream os = null;
        File novoArqDestino = null;
        boolean erro = false;
        try {
            int length;
            novoArqDestino = new File(diretorioDestino.getAbsoluteFile(), arquivoOrigem.getName());
            is = new FileInputStream(arquivoOrigem);
            os = new FileOutputStream(novoArqDestino);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            erro = true;
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("N\u00e3o foi poss\u00edvel copiar arquivo.", e);
        }
        catch (Exception e) {
            erro = true;
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("N\u00e3o foi poss\u00edvel copiar arquivo.", e);
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), e);
            }
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), e);
            }
            if (!erro && apagarOrigem) {
                arquivoOrigem.delete();
            }
            if (erro && null != novoArqDestino) {
                novoArqDestino.delete();
            }
            is = null;
            os = null;
            novoArqDestino = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void toFile(byte[] bFile, File destino) throws ArquivoUtilException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destino);
            fos.write(bFile);
            return;
        }
        catch (NullPointerException e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("Arquivo invalido ou inexistente.", e);
        }
        catch (FileNotFoundException e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("Arquivo invalido ou inexistente.", e);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("N\u00e3o foi poss\u00edvel escrever bytes no arquivo.", e);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("N\u00e3o foi poss\u00edvel escrever bytes no arquivo.", e);
        }
        finally {
            if (null != fos) {
                try {
                    try {
                        fos.close();
                        fos = null;
                    }
                    catch (IOException e) {
                        logger.debug(e.getMessage(), e);
                        fos = null;
                    }
                }
                catch (Throwable throwable) {
                    fos = null;
                    throw throwable;
                }
            }
        }
    }

    public static void escreverArquivo(File arquivo, String conteudo, boolean append) throws ArquivoUtilException {
        if (null == arquivo || !arquivo.isFile()) {
            throw new ArquivoUtilException("\u00c9 necess\u00e1rio informar um arquivo v\u00e1lido.");
        }
        OutputStreamWriter fw = null;
        try {
            arquivo.createNewFile();
            fw = new FileWriter(arquivo, append);
            fw.write(conteudo);
            fw.flush();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("N\u00e3o foi poss\u00edvel escrever texto no arquivo.", e);
        }
        finally {
            if (null != fw) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.debug(e.getMessage(), e);
                }
                fw = null;
            }
        }
    }

    public static void escreverArquivo(File arquivo, Throwable throwable, boolean append) throws ArquivoUtilException {
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            String conteudo = sw.toString();
            ArquivoUtil.escreverArquivo(arquivo, conteudo, append);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("N\u00e3o foi poss\u00edvel escrever excecao no arquivo.", e);
        }
        finally {
            if (null != pw) {
                try {
                    pw.close();
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), e);
                }
            }
            if (null != sw) {
                try {
                    sw.close();
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), e);
                }
            }
            pw = null;
            sw = null;
        }
    }

    public static boolean isZip(String nomeArquivoZip) {
        return TipoArquivo.isZip(nomeArquivoZip);
    }
}

