/*
 * Decompiled with CFR 0.152.
 */
package br.com.providernt.util;

import br.com.providernt.util.ArquivoUtil;
import br.com.providernt.util.ArquivoUtilException;
import com.thoughtworks.xstream.core.util.Base64Encoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Util {
    private static final Logger logger = LoggerFactory.getLogger(Base64Util.class);

    public static String fileToBase64(File file) throws ArquivoUtilException {
        FileInputStream fis = null;
        ByteBuffer bb = null;
        byte[] b = null;
        try {
            fis = new FileInputStream(file);
            int size = fis.available();
            b = new byte[size];
            fis.read(b);
            bb = ByteBuffer.wrap(b);
            String base64 = new Base64Encoder().encode(bb.array());
            logger.debug(base64);
            String string = base64;
            return string;
        }
        catch (NullPointerException e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("Arquivo invalido ou inexistente.", e);
        }
        catch (FileNotFoundException e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("Arquivo invalido ou inexistente.", e);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("N\u00e3o foi poss\u00edvel gerar Base64.", e);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.debug(e.getMessage(), e);
                }
            }
            fis = null;
            bb = null;
            b = null;
        }
    }

    public static void base64ToFile(String base64, File destino) throws ArquivoUtilException {
        byte[] fileBytes = null;
        try {
            fileBytes = new Base64Encoder().decode(base64);
            ArquivoUtil.toFile(fileBytes, destino);
        }
        catch (ArquivoUtilException e) {
            logger.debug(e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            throw new ArquivoUtilException("N\u00e3o foi poss\u00edvel converter Base64 em arquivo.", e);
        }
        finally {
            fileBytes = null;
        }
    }
}

