/*
 * Decompiled with CFR 0.152.
 */
package br.com.providernt.util;

import br.com.providernt.util.NekiUtil;
import br.com.providernt.util.NekiUtilException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValorExtenso {
    private static final Logger logger = LoggerFactory.getLogger(ValorExtenso.class);
    private static final String JUNCAO = "e";
    private static final String ESPACO = " ";
    private static final int UNIDADE = 1;
    private static final int DEZENA = 10;
    private static final int CENTENA = 100;
    private static final BigDecimal MAX_VALUE = new BigDecimal("999999999999999999999999999.99");

    public static void main(String[] args) {
        try {
            System.out.println(ValorExtenso.converter(new BigDecimal(3.156412378E7)));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
        }
    }

    public static String converter(BigDecimal valor) throws NekiUtilException {
        if (null == valor) {
            return "";
        }
        if (valor.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException(ValorExtenso.getMensagem("erro.02") + MAX_VALUE);
        }
        try {
            DecimalFormat nf = new DecimalFormat("###,###,###,###,###,###,###,###,##0.00", new DecimalFormatSymbols(new Locale("pt", "BR")));
            String valorFormat = String.valueOf(nf.format(valor));
            String[] val = valorFormat.toString().split("\\,");
            String[] inteiros = val[0].split("\\.");
            String cents = val[1];
            ArrayList<Long> listaValores = new ArrayList<Long>();
            for (int i = 0; i < inteiros.length; ++i) {
                listaValores.add(Long.parseLong(inteiros[i]));
            }
            listaValores.add(Long.parseLong(cents));
            return ValorExtenso.montar(listaValores);
        }
        catch (Exception e) {
            logger.debug(ValorExtenso.getMensagem("erro.01"), e);
            throw new NekiUtilException(ValorExtenso.getMensagem("erro.01"), e);
        }
    }

    private static String montar(List<Long> listaValores) {
        StringBuilder valorExtenso = new StringBuilder();
        int tamanhoLista = listaValores.size();
        for (int i = 0; i < tamanhoLista; ++i) {
            long valorBloco = listaValores.get(i);
            if ((valorBloco = ValorExtenso.paraPositivo(valorBloco)) <= 0L) continue;
            String blocoPorExtenso = ValorExtenso.getBloco(valorBloco);
            String qualificador = ValorExtenso.getQualificador(tamanhoLista, i, valorBloco);
            valorExtenso.append(ESPACO);
            valorExtenso.append(blocoPorExtenso);
            valorExtenso.append(ESPACO);
            valorExtenso.append(qualificador);
            int posicaoQualificador = tamanhoLista - (i + 1);
            if (posicaoQualificador == 1 && listaValores.get(i + 1) > 0L) {
                valorExtenso.append(" e");
            }
            logger.debug(blocoPorExtenso + ESPACO + qualificador);
        }
        logger.debug(valorExtenso.toString());
        return valorExtenso.toString().trim();
    }

    private static String getBloco(long bloco) {
        String textoBloco = "";
        textoBloco = (bloco = ValorExtenso.paraPositivo(bloco)) >= 100L ? ValorExtenso.getCentena(bloco) : (bloco >= 10L ? ValorExtenso.getDezena(bloco) : ValorExtenso.getUnidade(bloco));
        return textoBloco;
    }

    private static String getUnidade(long unidade) {
        unidade = ValorExtenso.paraPositivo(unidade);
        return ValorExtenso.getMensagem("unidade." + unidade);
    }

    private static String getDezena(long dezena) {
        String texto = null;
        if ((dezena = ValorExtenso.paraPositivo(dezena)) < 10L) {
            texto = ValorExtenso.getUnidade(dezena);
        } else if (dezena >= 100L) {
            texto = ValorExtenso.getCentena(dezena);
        } else {
            long resto = dezena % 10L;
            if (resto > 0L && dezena > 20L) {
                texto = ValorExtenso.getMensagem("dezena." + (dezena - resto));
                texto = texto + " e ";
                texto = texto + ValorExtenso.getUnidade(resto);
            } else {
                texto = ValorExtenso.getMensagem("dezena." + dezena);
            }
        }
        return texto;
    }

    private static String getCentena(long centena) {
        String texto = null;
        if ((centena = ValorExtenso.paraPositivo(centena)) < 10L) {
            texto = ValorExtenso.getUnidade(centena);
        } else if (centena < 100L) {
            texto = ValorExtenso.getDezena(centena);
        } else {
            long resto = centena % 100L;
            if (centena == 100L) {
                texto = ValorExtenso.getMensagem("centena." + centena + ".singular");
            } else {
                texto = ValorExtenso.getMensagem("centena." + (centena - resto));
                if (resto > 0L) {
                    texto = texto + " e ";
                    texto = texto + ValorExtenso.getDezena(resto);
                }
            }
        }
        return texto;
    }

    private static String getQualificador(int tamanhoLista, int posicaoAtual, long valorBloco) {
        String qualificador = null;
        int posicaoQualificador = tamanhoLista - (posicaoAtual + 1);
        qualificador = valorBloco > 1L ? ValorExtenso.getMensagem("qualificador." + posicaoQualificador + ".plural") : ValorExtenso.getMensagem("qualificador." + posicaoQualificador);
        return qualificador;
    }

    private static String getMensagem(String chave) {
        return NekiUtil.getResourceBundle("valorextenso").getString(chave);
    }

    private static long paraPositivo(long valor) {
        if (valor < 0L) {
            valor *= -1L;
        }
        return valor;
    }
}

