package br.com.bancooriginal.cyberbank.awt.janela;

import java.awt.Dimension;

import javax.swing.JFrame;

import br.com.bancooriginal.cyberbank.awt.janela.page.IPage;
import br.com.bancooriginal.cyberbank.util.CBUtil;

/**
 * Classe que controla a janela do sistema.
 * @author diego.dias
 *
 */
public class Janela extends JFrame {

	private static final long serialVersionUID = 3211148284028595490L;

	private static final int WIDTH = 550;
	private static final int HEIGHT= 600;
	
	private static Janela instance;
	
	private Janela(){
		
		setTitle(CBUtil.getMensagem("messages.cyberbank.title"));
		
		Dimension dim = new Dimension(WIDTH, HEIGHT);
		setSize(dim);
		setMinimumSize(dim);
		setMaximumSize(dim);
		setLocationRelativeTo(null);
		setResizable(false);
		setVisible(true);

	}
	
	/**
	 * Retorna a instancia da Janela.
	 * @return
	 */
	public static Janela getInstance(){
		if(null == instance){
			instance = new Janela();
		}
		return instance;
	}
	
	/**
	 * Metodo que exibe janela.
	 */
	public void show(IPage pagina){
		
		if(null != pagina){
			
			getContentPane().removeAll();
			
			/* MONTA PAGINA */
			pagina.exibir();
			
			/* COLOCA PAGINA NA JANELA */
			setContentPane(pagina.getContentPane());
		}
		
		getContentPane().setVisible(true);
		setVisible(true);
        setLocationRelativeTo(null);
        setDefaultCloseOperation(EXIT_ON_CLOSE);

	}
	
}
