package br.com.bancooriginal.cyberbank.awt.janela.page;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

import br.com.bancooriginal.cyberbank.awt.component.PainelImagem;
import br.com.bancooriginal.cyberbank.awt.component.WaitingDialog;
import br.com.bancooriginal.cyberbank.awt.janela.Janela;
import br.com.bancooriginal.cyberbank.enums.Ambiente;
import br.com.bancooriginal.cyberbank.enums.ComboControllerType;
import br.com.bancooriginal.cyberbank.exception.CyberBankException;
import br.com.bancooriginal.cyberbank.servico.client.SecurityClient;
import br.com.bancooriginal.cyberbank.util.CBUtil;
import br.com.bancooriginal.cyberbank.util.XMLUtil;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * Pagina Principal.
 * @author filipe.sa
 * @author diego.dias
 *
 */
public class PrincipalPage implements IPage {

	private final JPanel panel = new JPanel();
	
	public PrincipalPage(){
		
	
		panel.setLayout(new BorderLayout());
		//panel.setLayout(formLayout);
		
		//criacao do label com o titulo da janela
        JLabel logo = new JLabel(CBUtil.getMensagem("messages.cyberbank.title.page.principal"));
        logo.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 20));
        logo.setFont(new Font("Arial", Font.PLAIN, 18));
        logo.setForeground(Color.WHITE);
        
        //criacao da label da combo de operacoes
		JLabel selectAmbienteLabel = new JLabel("Selecione o ambiente:  ");
		JLabel selectOperationLabel = new JLabel(CBUtil.getMensagem("messages.cyberbank.label.select.operation")+"  ");

		//Combo com a escolha do tipo de operacao
		final JComboBox operationsCombo = new JComboBox();
		//adicao de listener para mudanca de valor da combo
		operationsCombo.addItemListener(new ItemListener() {
			
	        public void itemStateChanged(ItemEvent itemSelected) {
	        	
	        	if(null != itemSelected && itemSelected.getStateChange() == ItemEvent.SELECTED){
	        		
	        		ComboControllerType item = (ComboControllerType) itemSelected.getItem();
	        		
	        		IPage page = null;
	        		
	        		//Quando a escolha e realizada a pagina corresspondente abre
	        		if(ComboControllerType.PARAMETRIZACAO.equals(item)){
	        			
	        			page = new ParametrizacaoPage();
	        			
	        		} else if(ComboControllerType.LANCAMENTO_CC.equals(item)){
	        			
	        			page = new LancamentoPage();
	        			
	        		} else if(ComboControllerType.GERAR_SESSIONID.equals(item)){
	        			
	        			int opcao = JOptionPane.showConfirmDialog(null, "Você quer mesmo criar uma nova sessão?", "Nova Sessão",  JOptionPane.OK_CANCEL_OPTION);
	        			
	        			//significa que a escolha foi positiva
	        			if(opcao == 0){
	        				
		        			//No caso de escolher gerar nova sessao, o cliente do webservice de geracao de sessao
		        			//sera chamado automaticamente.
		        			
		        			//Primeiro eh criado o indicado de espera
		        			final WaitingDialog waitingDialog = new WaitingDialog(panel);
		    				
		        			//Criamos um worker para que seja acionado o indicador de espera
		        			//enquanto a tarefa de chamar o webservice roda em background
		    			    SwingWorker<String, Void> worker = new SwingWorker<String, Void>() {

		    			    
		    			    	 @Override
		    				     protected String doInBackground() throws InterruptedException {
		    			    		 
		    			    		 SecurityClient securityClient = new SecurityClient();
		    		        			
	    		        			try {
	    		        				
	    		        				//chamamos o cliente do webservice de autenticacao
	    								securityClient.autenticar();
	    								
	    							} catch (CyberBankException e) {
	    	
	    								JOptionPane.showMessageDialog (null, e.getMessage(), "Status Login", JOptionPane.INFORMATION_MESSAGE);
	    								return "error";
	    								
	    							} 
	    		        			
	    		        			JOptionPane.showMessageDialog (null, "Sessão criada com sucesso!", "Status Login", JOptionPane.INFORMATION_MESSAGE);

		    			    		 return "ok";
		    			    	 }
		    			    	
		    			    	 
		    			    	 //metodo chamado quando a tarefa de background eh finalizada
		    			    	 //neste caso apenas fechamos o indicador de espera
		    			    	 @Override
	    				        protected void done() {
	    				        	
	    				        	waitingDialog.dispose();
	    				        	
	    				        }
		    			    	 
		    			    };
		    			    
		    			    //o worker eh ordenado a executar a tarefa de background
		    			    //e o indicador de espera eh feito visivel
		    			    worker.execute();
		    			    waitingDialog.setVisible(true);
		    			    try {
		    			        worker.get();
		    			    } catch (Exception e1) {
		    			        e1.printStackTrace();
		    			    }
		        			
	        				
	        			}
	        			
	        			//voltamos a combo para --select--
	        			operationsCombo.setSelectedIndex(0);

	        		}
	        		
	        		if(!ComboControllerType.GERAR_SESSIONID.equals(item)){
	        			Janela.getInstance().show(page);
	        		}
	        		
	        		
	        	}
	        }
	    });
		operationsCombo.addItem(ComboControllerType.SELECT);
		operationsCombo.addItem(ComboControllerType.PARAMETRIZACAO);
		operationsCombo.addItem(ComboControllerType.LANCAMENTO_CC);
		operationsCombo.addItem(ComboControllerType.GERAR_SESSIONID);

		
		//Combo com a escolha do ambiente onde sera realizada a operacao
		final JComboBox ambienteCombo = new JComboBox();
		ambienteCombo.addItemListener(new ItemListener() {
	        public void itemStateChanged(ItemEvent itemSelected) {
	        	
	        	//quando o valor muda, o mesmo eh persistido no xml parametrizacao.xml
	        	Ambiente ambienteSelecionado = (Ambiente) itemSelected.getItem();
	        	
	        	XMLUtil.escreverAtributoParametrizacao("ambiente", ambienteSelecionado.name());
	  
	        }
	    });
		
		//o valor persistido no xml e setado na combo quando a pagina e criada
		Ambiente ambienteAtual = Ambiente.valueOf(XMLUtil.recuperarAtributoParametrizacao("ambiente"));
		ambienteCombo.addItem(ambienteAtual);
		if(ambienteAtual != Ambiente.DES){
			ambienteCombo.addItem(Ambiente.DES);
		}
		if(ambienteAtual != Ambiente.ACE){
			ambienteCombo.addItem(Ambiente.ACE);
		}
		if(ambienteAtual != Ambiente.HOM){
			ambienteCombo.addItem(Ambiente.HOM);
		}
		
		//criacao do painel com a imagem no fundo
		PainelImagem painelTopo = new PainelImagem(CBUtil.createImage("images/barra.png"));
		
		PainelImagem painelLogo = new PainelImagem(CBUtil.createImage("images/logooriginal.png"));
		Dimension dim = new Dimension(400, 200);
		painelLogo.setPreferredSize(dim);

		FormLayout formLayout = new FormLayout(
				//Colunas
				"right:pref:grow, left:pref:grow", 
				//Linhas
				"40px, 40px, 40px, 40px, 210px, 90px, 40px"
				);
		JPanel painelCentral = new JPanel(formLayout);
		
		panel.add(painelTopo, BorderLayout.NORTH);
		panel.add(painelCentral, BorderLayout.CENTER);
		
		painelTopo.add(logo);
		
		CellConstraints cc = new CellConstraints();
	    
		painelCentral.add(selectAmbienteLabel, cc.xy (1, 2));
		painelCentral.add(ambienteCombo, cc.xy (2, 2));
		painelCentral.add(selectOperationLabel, cc.xy (1, 3));
		painelCentral.add(operationsCombo, cc.xy (2, 3));
		painelCentral.add(painelLogo, cc.xywh (1, 6, 2, 1, "left, bottom"));
		
		JLabel creditos = new JLabel("    Cliente Contas Correntes 1.0 - 14/08/2014");
		painelCentral.add(creditos, cc.xywh (1, 7, 2, 1, "left, bottom"));
		
		
	}
	
	@Override
	public void exibir(){
		montar();
	}
	
	@Override
	public Container getContentPane() {
		return this.panel;
	}
	
	private void montar(){
		
		
	}
	

	
	/**
	 * Classe interna de controle para Item da Combo principal.
	 * @author diego.dias
	 *
	 */
	class ComboItem{
		
		private final ComboControllerType id;
		private final String text;
		
		public ComboItem(ComboControllerType id, String text){
			this.id = id;
			this.text = text;
		}

		public ComboControllerType getId() {
			return id;
		}

		public String getText() {
			return text;
		}

		@Override
		public String toString() {
			return text;
		}

	}
}
