package br.com.bancooriginal.cyberbank.awt.janela.page;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;

import br.com.bancooriginal.cyberbank.awt.component.PainelImagem;
import br.com.bancooriginal.cyberbank.awt.janela.Janela;
import br.com.bancooriginal.cyberbank.dto.Lancamento;
import br.com.bancooriginal.cyberbank.util.CBUtil;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * Pagina que apresenta o resultado do lancamento em conta corrente.
 * @author filipe.sa
 * @author diego.dias
 *
 */
public class ResultadoPage implements IPage {

	private final JPanel panel = new JPanel();
	
	private final int alinhamentoLabel = SwingConstants.RIGHT;
	private final EmptyBorder border = new EmptyBorder(20, 20, 20, 20);
	
	private final Lancamento lancamento;
	
	public ResultadoPage(Lancamento lancamento){
		this.lancamento = lancamento;
	}
	
	@Override
	public void exibir(){
		montar();
	}
	
	@Override
	public Container getContentPane() {
		return this.panel;
	}
	
	
	private void montar(){
		
		panel.setLayout(new BorderLayout());
		
        JLabel logo = new JLabel("<html>"+CBUtil.getMensagem("messages.cyberbank.title.page.resultado")+"</html>");
        logo.setFont(new Font("Arial", Font.PLAIN, 18));
        logo.setForeground(Color.WHITE);
        String naoinformado = "não informado";
        
        /* LABEL E TEXTFIELDS */
		JLabel numContaLabel = createLabel("numConta");
		JLabel numConta = new JLabel(lancamento.getNumConta()+"");
		
		JLabel transacaoLabel = createLabel("transacao");
		JLabel transacao = new JLabel(lancamento.getTransacao()+"");
		
		JLabel motivoLabel = createLabel("motivo");
		JLabel motivo = new JLabel(lancamento.getMotivo()+"");
		
		JLabel valorLabel = createLabel("valor");
		JLabel valor = new JLabel(lancamento.getValor()+"");
		
		JLabel dataLabel = createLabel("data");
		JLabel data = new JLabel(lancamento.getData());
		
		JLabel comentarioLabel = createLabel("comentario");
		JLabel comentario = new JLabel(lancamento.getComentario() != null ? lancamento.getComentario() : naoinformado);
		
		JLabel categoriaLabel = createLabel("categoria");
		JLabel categoria = new JLabel(lancamento.getCategoria() != null ? lancamento.getCategoria() : naoinformado);
		
		JLabel valorCheque24Label = createLabel("valorCheque24");
		JLabel valorCheque24 = new JLabel(lancamento.getValorCheque24() !=  null ? lancamento.getValorCheque24() : naoinformado);
		
		JLabel valorCheque48Label = createLabel("valorCheque48");
		JLabel valorCheque48 = new JLabel(lancamento.getValorCheque48() != null ? lancamento.getValorCheque48() : naoinformado);
		
		JLabel numDocumentoLabel = createLabel("numDocumento");
		JLabel numDocumento = new JLabel(lancamento.getNumDocumento() != null ? lancamento.getNumDocumento() : naoinformado);
		
		JLabel reversalFlagLabel = createLabel("reversalFlag");
		JLabel reversalFlag = new JLabel(lancamento.getReversalFlag().toString());
		
		JLabel reversalNumberLabel = createLabel("reversalNumber");
		JLabel reversalNumber = new JLabel(lancamento.getReversalNumber() != null ? lancamento.getReversalNumber() : naoinformado);
		
		
		
		JButton btOk = createBtOk();
		JButton btVoltar = createBtVoltar();
		
		 FormLayout formLayout = new FormLayout(
					//Colunas
					"right:pref:grow(.35), left:pref:grow(.65)", 
					//Linhas
					"center:50px, "+
					"17px, 17px, 17px, 17px, 17px, 17px,"+ 
					"17px, 17px, 17px, 17px, 17px, 17px,"+
					"60px, 100px, 50px, 40px"
					);
		 

		PainelImagem painelTopo = new PainelImagem(CBUtil.createImage("images/barra.png"));
		
		JPanel painelCentral = new JPanel();
		painelCentral.setLayout(formLayout);

		JPanel painelBotao = new JPanel(new GridLayout(1, 3));
		painelBotao.setBorder(BorderFactory.createEmptyBorder(0, 20, 30, 20));
		
		painelBotao.add(btOk);
		painelBotao.add(btVoltar);
		
		panel.add(painelTopo, BorderLayout.NORTH);
		panel.add(painelCentral, BorderLayout.CENTER);
		panel.add(painelBotao, BorderLayout.SOUTH);
			
		painelTopo.add(logo);
		
		CellConstraints cc = new CellConstraints();
		
		JLabel tituloentrada = new JLabel("DADOS DE ENTRADA");
		tituloentrada.setFont(new Font("Arial", Font.BOLD, 16));
		painelCentral.add(tituloentrada, cc.xywh (1, 1, 2, 1, "center, fill"));
		
		painelCentral.add(numContaLabel, cc.xy (1, 2));
        painelCentral.add(numConta, cc.xy (2, 2));
        
        painelCentral.add(transacaoLabel, cc.xy (1, 3));
        painelCentral.add(transacao, cc.xy (2, 3));
        
        painelCentral.add(motivoLabel, cc.xy (1, 4));
        painelCentral.add(motivo, cc.xy (2, 4));
        
        painelCentral.add(valorLabel, cc.xy (1, 5));
        painelCentral.add(valor, cc.xy (2, 5));
        
        painelCentral.add(dataLabel, cc.xy (1, 6));
        painelCentral.add(data, cc.xy (2, 6));
        
        painelCentral.add(comentarioLabel, cc.xy (1, 7));
        painelCentral.add(comentario, cc.xy (2, 7));
        
        painelCentral.add(categoriaLabel, cc.xy (1, 8));
        painelCentral.add(categoria, cc.xy (2, 8));
        
        painelCentral.add(valorCheque24Label, cc.xy (1, 9));
        painelCentral.add(valorCheque24, cc.xy (2, 9));
        
        painelCentral.add(valorCheque48Label, cc.xy (1, 10));
        painelCentral.add(valorCheque48, cc.xy (2, 10));
        
        painelCentral.add(numDocumentoLabel, cc.xy (1, 11));
        painelCentral.add(numDocumento, cc.xy (2, 11));
        
        painelCentral.add(reversalFlagLabel, cc.xy (1, 12));
        painelCentral.add(reversalFlag, cc.xy (2, 12));
        
        painelCentral.add(reversalNumberLabel, cc.xy (1, 13));
        painelCentral.add(reversalNumber, cc.xy (2, 13));
        
        JLabel resultadooperacao = new JLabel("RESULTADO DA OPERAÇÃO");
        resultadooperacao.setFont(new Font("Arial", Font.BOLD, 16));
		painelCentral.add(resultadooperacao, cc.xywh (1, 14, 2, 1, "center, fill"));

		
		if(null != lancamento.getErrorList() && !"".equals(lancamento.getErrorList())){
			
				String[] erros = lancamento.getErrorList().split("###");
			
				JLabel errorListLabel = new JLabel("Error_List   ");
		        JTextArea errorList = new JTextArea();
		        errorList.setEditable(false);
				errorList.setLineWrap(true);
				errorList.setColumns(25);
				
				for(String e:erros){
					errorList.append(e);
				}
				
				painelCentral.add(errorListLabel, cc.xy (1, 15));
				painelCentral.add(errorList, cc.xy (2, 15));
			
		}else{
		        
		        JLabel msgMovementLabel = new JLabel("Documento de referência:   ");
		        JTextArea msgMovement = new JTextArea(lancamento.getResposta());
		        msgMovement.setEditable(false);
		        msgMovement.setLineWrap(true);
				msgMovement.setColumns(25);
				painelCentral.add(msgMovementLabel, cc.xy (1, 15));
				painelCentral.add(msgMovement, cc.xy (2, 15));
			
		}
		

		
	}
	
	
	private JLabel createLabel(String text){
		JLabel label = new JLabel(CBUtil.getMensagem("messages.cyberbank.label.lancamento."+text), alinhamentoLabel);
		label.setBorder(border);
		return label;
	}
	
	
	private JButton createBotao(String text) {
		
		JButton botao = new JButton(text);
		botao.setToolTipText(text);
		botao.setBorder(new EmptyBorder(6, 5, 6, 5));
		botao.add(Box.createRigidArea(new Dimension(100, 20)));
		return botao;
		
	}

	private JButton createBtOk() {
		
		JButton botao = createBotao(CBUtil.getMensagem("messages.cyberbank.button.ok"));
		botao.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {

				PrincipalPage principal = new PrincipalPage();
				Janela.getInstance().show(principal);
				
			}
		});
		
		return botao;
	}
	
	private JButton createBtVoltar(){
		
		JButton botao = createBotao("voltar");
		botao.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {

				LancamentoPage lancamentoPage = new LancamentoPage(lancamento);
				Janela.getInstance().show(lancamentoPage);
				
			}
		});
		
		return botao;
		
	}

	
	
}
