package br.com.bancooriginal.cyberbank.main;

import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import br.com.bancooriginal.cyberbank.awt.janela.Janela;
import br.com.bancooriginal.cyberbank.awt.janela.page.PrincipalPage;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.theme.DesertBlue;

/**
 * Classe principal do projeto que inicia o aplicativo.
 * Para iniciar o aplicativo a partir do eclipse, basta clicar nesta classe com o botao
 * direito e escolher >> Run As >> Java Application 
 * 
 * @author diego.dias
 *
 */
public class App {

	public static void main(String[] args) {
		
		Plastic3DLookAndFeel.setPlasticTheme(new DesertBlue());
		
		try {
			UIManager.setLookAndFeel(new Plastic3DLookAndFeel());
		} catch (UnsupportedLookAndFeelException e) {
			e.printStackTrace();
		}

		
		PrincipalPage principal = new PrincipalPage();
		Janela.getInstance().show(principal);
		
	}
	
}
