package br.com.bancooriginal.cyberbank.util;

import java.awt.Image;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.swing.ImageIcon;

import br.com.bancooriginal.cyberbank.main.App;

/**
 * Classe que serve para recuperar valores do arquivo de propriedades.
 * 
 * @author diego.dias
 *
 */
public class CBUtil {

	public static final String ARQUIVO_XML = "parametrizacao.xml";
	
	/* NOME BASE DO PROPERTIES. EX.: errors_pt_BR.properties */
	private final static String RB_MESSAGES = "messages";
	
	public static ResourceBundle getResourceBundleNekiUtil(String baseName){
		Locale defaultLocale = Locale.getDefault();
		return ResourceBundle.getBundle(baseName, defaultLocale, CBUtil.class.getClassLoader());
	}
	
	public static ResourceBundle getResourceBundle(String baseName){
		Locale defaultLocale = Locale.getDefault();
		return ResourceBundle.getBundle(baseName, defaultLocale);
	}
	
	public static String getMensagem(String chave) {
		try{
			return getResourceBundle(RB_MESSAGES).getString(chave);
		} catch (Exception e){
			return chave;
		}
	}
	
	public static String getMensagem(String chave, Object... argumentos) {
		String mensagem = getMensagem(chave);
		// Retorna a mensagem formatada
		return MessageFormat.format(mensagem, argumentos);
	}
	
	
	
	public static Image createImage(String path) {
		return createImage(path, null);
	}
	public static Image createImage(String path, String description) {
		URL imageURL = App.class.getClassLoader().getResource(path);
		
		if (imageURL == null) {
			imageURL = App.class.getClassLoader().getResource("resources/" + path);
		}
		
		if (imageURL == null) {
			return null;
		} else {
			return (new ImageIcon(imageURL, description)).getImage();
		}
	}
	
}
