package br.com.bancooriginal.cyberbank.servico.client;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.w3c.dom.Node;

/**
 * Classe handler que pode manipular a mensagem antes de ser enviada e quando retorna
 * antes de ser transformada.
 * 
 * @author filipe.sa
 *
 */
public class MensagemHandler implements SOAPHandler<SOAPMessageContext>{

	@Override
	public void close(MessageContext context) {
		
	}

	@Override
	public boolean handleFault(SOAPMessageContext messageContext) {
		
		return true;
	}

	/**
	 * Metodo que pode manipular a mensagem na entrada e na saida.
	 */
	@Override
	public boolean handleMessage(SOAPMessageContext messageContext) {
		
		
		//UTILIZADO PARA DEBUG DA MENSAGEM
		if((Boolean) messageContext.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY)){
			
			System.out.println("MENSAGEM SAINDO");
			
		}else{
			
			System.out.println("MENSAGEM CHEGANDO");
			
			try {
				
				SOAPBody body = messageContext.getMessage().getSOAPBody();
				
				if(body.hasFault()){
					
					System.out.println("EXISTE FAULT");
					
					//WORKAROUND DEVIDO A UM PROBLEMA ENCONTRADO NA MENSAGEM
					//DEVOLVIDA PELO CMM QUE NÃO ENVIA FAULTCODE NEM FAULTSTRING
					body.getFault().setFaultCode("NS1:Sender");
					body.getFault().setFaultString("errors");
					
					//MAIS UM WORKAROUND DEVIDO A UM PROBLEMA ENCONTRADO NA MENSAGEM DEVOLVIDA PELO CMM
					//QUE ENVIA UM NO NULO COM O RESPONSE DENTRO DO BODY DA MENSAGEM. ESTE NO PRECISA SER REMOVIDO
					//POIS A MENSAGEM DEVE ENVIAR APENAS A FAULT COMO BODY DA MENSAGEM. QUANDO O RETORNO FOR CORRRIGIDO PELA TECHNISYS
					//AS DUAS LINHAS A SEGUIR DEVEM SER REMOVIDAS.
					Node oldChild = body.getFirstChild();
					body.removeChild(oldChild);
					
				}
				
			} catch (SOAPException e) {
				e.printStackTrace();
			}
			
			
		}
		
		SOAPMessage msg = messageContext.getMessage();

       try {
    	   
    	   //USADO PARA DEBUG - ESCREVE A MENSAGEM NO CONSOLE
           msg.writeTo(System.out); 
           
       } catch (SOAPException ex) {
    	   ex.printStackTrace();
       } catch (IOException ex) {
    	   ex.printStackTrace();
       }
		
		return true;
	}

	@Override
	public Set<QName> getHeaders() {
		return Collections.emptySet();
	}

}
