package br.com.bancooriginal.cyberbank.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import br.com.bancooriginal.cyberbank.dto.Parametrizacao;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.Dom4JDriver;

/**
 * Classe que serve para manipular o arquivo parametrizacao.xml.
 * 
 * @author filipe.sa
 * @author diego.dias
 *
 */
public class XMLUtil {

	private static final String NAME_XML = "parametrizacao";
	
	public static void escreverXML(Parametrizacao c, File arquivo) {

		FileOutputStream gravar = null;
		
		try {
			
			XStream xStream = new XStream();
			xStream.alias(NAME_XML, Parametrizacao.class);

			gravar = new FileOutputStream(arquivo);
			gravar.write(xStream.toXML(c).getBytes());

		} catch (Exception e) {
			
			e.printStackTrace();
			
		} finally {
			
			if (null != gravar) {
				
				try {
					
					gravar.close();
					
				} catch (IOException e) {

					e.printStackTrace();
					
				}
			}
		}

	}

	public static Parametrizacao lerConfiguracoes(File arquivo) {
		
		Parametrizacao c = null;
		
		try {
			
			XStream xStream = new XStream(new Dom4JDriver());
			xStream.alias(NAME_XML, Parametrizacao.class);
			xStream.processAnnotations(Parametrizacao.class);

			BufferedReader input = new BufferedReader(new FileReader(arquivo));
			c = (Parametrizacao) xStream.fromXML(input);
			input.close();

		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		
		return c;
	}
	
	public static String recuperarAtributoParametrizacao(String atributo){
		
		Parametrizacao parametrizacao = lerConfiguracoes(new File("parametrizacao.xml"));
		
		String nomeMetodo = "get"+atributo.substring(0,1).toUpperCase()+atributo.substring(1);
		
		Method method = null;
		
		try {
			method = parametrizacao.getClass().getMethod(nomeMetodo);
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		}
		
		String valor = null;
		
		try {
			valor = (String) method.invoke(parametrizacao);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		
		return valor;
	}
	
	public static void escreverAtributoParametrizacao(String atributo, String value){
		
		Parametrizacao parametrizacao = lerConfiguracoes(new File("parametrizacao.xml"));
		
		String nomeMetodo = "set"+atributo.substring(0,1).toUpperCase()+atributo.substring(1);
		
		Class<?> argumentos[] = new Class[1];  
		argumentos[0] = String.class;
		
		Method method = null;
		
		try {
			method = parametrizacao.getClass().getMethod(nomeMetodo, argumentos);
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		}
		
		Object arglist[] = new Object[1];  
        arglist[0] = value;  
		
		try {
			method.invoke(parametrizacao, value);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		
		escreverXML(parametrizacao, new File("parametrizacao.xml"));
	}

}
